/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.entity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import earth.terrarium.handcrafted.common.block.SittableBlock;
import earth.terrarium.handcrafted.common.registry.ModEntityTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4969;
import net.minecraft.class_5321;
import net.minecraft.class_5569;
import net.minecraft.class_6328;

@class_6328
public class SittingEntity
extends class_1297 {
    public static final Multimap<class_5321<class_1937>, class_2338> SITTING_POSITIONS = ArrayListMultimap.create();
    private class_238 shape;
    private boolean remove;
    private boolean canRotate;

    public SittingEntity(class_1299<? extends class_1297> entityType, class_1937 level) {
        super(entityType, level);
        this.method_31744(class_5569.field_27243);
    }

    public SittingEntity(class_1937 level, class_238 shape) {
        super((class_1299)ModEntityTypes.SEAT.get(), level);
        this.shape = SittingEntity.copyAABB(shape);
    }

    public static SittingEntity of(class_1937 level, class_2338 pos, class_2350 dir) {
        class_2680 state = level.method_8320(pos);
        class_238 shape = new class_238(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof SittableBlock) {
            SittableBlock seat = (SittableBlock)class_22482;
            shape = seat.getSeatSize(state);
        }
        SittingEntity entity = new SittingEntity(level, shape);
        if (dir != null) {
            entity.method_36456(dir.method_10144());
        } else {
            entity.canRotate = true;
        }
        entity.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        return entity;
    }

    private static class_238 copyAABB(class_238 aabb) {
        return new class_238(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1325, aabb.field_1324);
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this, this.canRotate ? 1 : 0);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.canRotate = packet.method_11166() == 1;
    }

    public boolean method_5655() {
        return true;
    }

    public boolean method_5782() {
        return true;
    }

    public boolean method_5727(double x, double y, double z) {
        return false;
    }

    public class_243 method_24829(class_1309 passenger) {
        return class_4969.method_26156((class_1299)passenger.method_5864(), (class_1941)this.field_6002, (class_2338)this.method_24515()).orElse(super.method_24829(passenger));
    }

    public void method_5773() {
        super.method_5773();
        if (!(this.field_6002.method_8608() || this.field_6002.method_8320(this.method_24515()).method_26204() instanceof SittableBlock && !this.remove)) {
            this.removeSeat();
        }
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (!this.field_6002.method_8608() && this.method_5685().isEmpty()) {
            this.remove = true;
        }
    }

    public void removeSeat() {
        SITTING_POSITIONS.get((Object)this.field_6002.method_27983()).remove(this.method_24515());
        this.method_31472();
    }

    protected class_238 method_33332() {
        if (this.shape == null) {
            return super.method_33332();
        }
        return this.shape.method_996(this.method_24515());
    }

    public double method_5621() {
        if (this.shape == null) {
            return super.method_5621();
        }
        return this.shape.method_17940() * 0.75;
    }

    protected void clampRotation(class_1297 entityToUpdate) {
        entityToUpdate.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entityToUpdate.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_5982 += g - f;
        entityToUpdate.method_36456(entityToUpdate.method_36454() + g - f);
        entityToUpdate.method_5847(entityToUpdate.method_36454());
    }

    public void method_5644(class_1297 entityToUpdate) {
        if (!this.canRotate) {
            this.clampRotation(entityToUpdate);
        }
    }

    public void method_31744(class_5569 levelCallback) {
        super.method_31744((class_5569)new WrapedLevelCallBack(levelCallback));
    }

    protected void method_5693() {
    }

    protected void method_5749(class_2487 compound) {
    }

    protected void method_5652(class_2487 compound) {
    }

    private class WrapedLevelCallBack
    implements class_5569 {
        private final class_5569 callback;

        public WrapedLevelCallBack(class_5569 callback) {
            this.callback = callback;
        }

        public void method_31749() {
            if (this.callback != null) {
                this.callback.method_31749();
                class_2248 class_22482 = SittingEntity.this.field_6002.method_8320(SittingEntity.this.method_24515()).method_26204();
                if (class_22482 instanceof SittableBlock) {
                    SittableBlock seat = (SittableBlock)class_22482;
                    SittingEntity.this.shape = seat.getSeatSize(SittingEntity.this.field_6002.method_8320(SittingEntity.this.method_24515()));
                }
            } else {
                SittingEntity.this.shape = null;
            }
        }

        public void method_31750(class_1297.class_5529 reason) {
            if (this.callback != null) {
                this.callback.method_31750(reason);
            }
        }
    }
}

